% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixregression.R
\name{trimmix}
\alias{trimmix}
\title{Trimmed Likelihood Estimator}
\usage{
trimmix(x, y, k = 2, alpha = 0.95, numini = 20)
}
\arguments{
\item{x}{explanatory variables matrix with rows for each observation}

\item{y}{response variable vector}

\item{k}{number of components, default is 2}

\item{alpha}{proportion of data to be keep according to likelihood range from 0-1, default is 0.95}

\item{numini}{number of initial values, default is 20.}
}
\value{
theta: estimated best parameters according to likelihood: beta for intercept ,beta for variables, sigma, proportion.
finallikelihood: likelihood of the best estimated parameters
likelihoodseq: all likelihood for all parameters estimated from initial values
}
\description{
Trimmed Likelihood Estimator
}
\examples{
library(fpc)
data('tonedata')
y=tonedata$tuned
x=tonedata$stretchratio
k=160;x[151:k]=0;y[151:k]=5
est_TLE=trimmix(x,y,2,0.95,numini=1);
TLE=est_TLE$theta
}
