% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fresult.R
\name{Fresult}
\alias{Fresult}
\title{Full result list}
\usage{
Fresult(iso.C, iso.D)
}
\arguments{
\item{iso.C}{result from the first labeled precusor from Exp. C}

\item{iso.D}{result from the second labled precusor from Exp. D}
}
\value{
file containing the all the possible combined results. Full list, but redundant
}
\description{
export full isotope labeled result list
}
\examples{
data(lcms)
explist <- prefilter(lcms[1: 500, ]) # use a subset of lcms data as example
exp.B <- explist$exp.B[, -2]
exp.C <- explist$exp.C[, -2]
exp.D <- explist$exp.D[, -2]
iso.C <- diso(iso1 = 'H2', n11 = 4, n12 = 3, exp.base = exp.B, exp.iso = exp.C)
iso.D <- diso(iso1 = 'C13', n11 = 9, n12 = 6, iso2 = 'N15', n21 = 1, n22 = 0,
exp.base = iso.C[,1:2], exp.iso = exp.D)
full_Result <- Fresult(iso.C, iso.D)

}
