% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{rarefy_sample_count_by_modality}
\alias{rarefy_sample_count_by_modality}
\title{Rarefy (equalize) the number of samples per modality of a factor}
\usage{
rarefy_sample_count_by_modality(physeq, fact, rngseed = FALSE, verbose = TRUE)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{fact}{(required): The variable to rarefy. Must be present in
the \code{sam_data} slot of the physeq object.}

\item{rngseed}{(Optional). A single integer value passed to set.seed,
which is used to fix a seed for reproducibly random number generation
(in this case, reproducibly random subsampling). If set to FALSE, then no
iddling with the RNG seed is performed,
and it is up to the user to appropriately call}

\item{verbose}{(logical). If TRUE, print additional informations.}
}
\value{
A new \code{\link{phyloseq-class}} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
table(data_fungi_mini@sam_data$Height)
data_fungi_mini2 <- rarefy_sample_count_by_modality(data_fungi_mini, "Height")
table(data_fungi_mini2@sam_data$Height)
if (requireNamespace("patchwork")) {
  ggvenn_pq(data_fungi_mini, "Height") + ggvenn_pq(data_fungi_mini2, "Height")
}
}
\seealso{
\code{\link[=accu_plot_balanced_modality]{accu_plot_balanced_modality()}}
}
\author{
Adrien Taudière
}
