% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{upset_test_pq}
\alias{upset_test_pq}
\title{Test for differences between intersections}
\usage{
upset_test_pq(
  physeq,
  fact,
  var_to_test = "OTU",
  min_nb_seq = 0,
  na_remove = TRUE,
  numeric_fonction = sum,
  ...
)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{fact}{(required): Name of the factor to cluster samples by modalities.
Need to be in \code{physeq@sam_data}.}

\item{var_to_test}{(default c("OTU")) : a vector of column present in
the tax_table slot from the physeq object}

\item{min_nb_seq}{minimum number of sequences by OTUs by
samples to take into count this OTUs in this sample. For example,
if min_nb_seq=2,each value of 2 or less in the OTU table
will not count in the venn diagram}

\item{na_remove}{: if TRUE (the default), NA values in fact are removed
if FALSE, NA values are set to "NA"}

\item{numeric_fonction}{(default : sum) the function for numeric vector
useful only for complex plot (see examples)}

\item{...}{other arguments passed on to the \code{\link[ComplexUpset:upset_test]{ComplexUpset::upset_test()}}}
}
\value{
A \code{\link{ggplot}}2 plot
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
data(data_fungi)
upset_test_pq(data_fungi, "Height", var_to_test = c("OTU", "Class", "Guild"))
upset_test_pq(data_fungi, "Time")

}
\seealso{
\code{\link[=upset_pq]{upset_pq()}}
}
\author{
Adrien Taudière
}
