% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targets_misc.R
\name{filter_trim}
\alias{filter_trim}
\title{A wrapper of the function \code{\link[dada2:filterAndTrim]{dada2::filterAndTrim()}} to use in
\href{https://books.ropensci.org/targets/}{targets} pipeline}
\usage{
filter_trim(
  fw = NULL,
  rev = NULL,
  output_fw = file.path(paste(getwd(), "/output/filterAndTrim_fwd", sep = "")),
  output_rev = file.path(paste(getwd(), "/output/filterAndTrim_rev", sep = "")),
  return_a_vector = FALSE,
  ...
)
}
\arguments{
\item{fw}{(required) a list of forward fastq files}

\item{rev}{a list of reverse fastq files for paired end trimming}

\item{output_fw}{Path to output folder for forward files. By default,
this function will create
a folder "output/filterAndTrim_fwd" in the current working directory.}

\item{output_rev}{Path to output folder for reverse files. By default,
this function will create
a folder "output/filterAndTrim_fwd" in the current working directory.}

\item{return_a_vector}{(logical, default FALSE) If true, the return is
a vector of path (usefull when used with
targets::tar_targets(..., format="file"))}

\item{...}{Other parameters passed on to \code{\link[dada2:filterAndTrim]{dada2::filterAndTrim()}} function.}
}
\value{
A list of files. If rev is set, will return a list of two lists.
The first list is a list of forward files, and the second one
is a list of reverse files.
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-maturing-blue" alt="lifecycle-maturing"></a>
}}


This function filter and trim (with parameters passed on to
\code{\link[dada2:filterAndTrim]{dada2::filterAndTrim()}} function) forward sequences or paired end
sequence if 'rev' parameter is set. It return the list of files to
subsequent analysis in a targets pipeline.
}
\examples{
testFastqs_fw <- c(
  system.file("extdata", "sam1F.fastq.gz", package = "dada2"),
  system.file("extdata", "sam2F.fastq.gz", package = "dada2")
)
testFastqs_rev <- c(
  system.file("extdata", "sam1R.fastq.gz", package = "dada2"),
  system.file("extdata", "sam2R.fastq.gz", package = "dada2")
)

filt_fastq_fw <- filter_trim(testFastqs_fw, output_fw = tempdir())
derep_fw <- derepFastq(filt_fastq_fw[1])
derep_fw

\dontrun{
filt_fastq_pe <- filter_trim(testFastqs_fw,
  testFastqs_rev,
  output_fw = paste0(tempdir(), "/", "fw"),
  output_rev = paste0(tempdir(), "rev")
)
derep_fw_pe <- derepFastq(filt_fastq_pe[[1]])
derep_rv_pe <- derepFastq(filt_fastq_pe[[2]])
derep_fw_pe
derep_rv_pe
}
}
\seealso{
\code{\link[dada2:filterAndTrim]{dada2::filterAndTrim()}}
}
\author{
Adrien Taudière
}
