% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speedyseq_functions.R
\name{unique_or_na}
\alias{unique_or_na}
\title{Get the unique value in x or NA if none}
\usage{
unique_or_na(x)
}
\arguments{
\item{x}{A vector}
}
\value{
Either a single value (if \code{unique(x)} return a single value) or a NA
}
\description{
If \code{unique(x)} is a single value, return it; otherwise, return an NA of the
same type as \code{x}. If \code{x} is a factor, then the levels and ordered status
will be kept in either case. If \code{x} is a non-atomic vector (i.e. a list),
then the logical \code{NA} will be used.
}
\examples{
f <- factor(c("a", "a", "b", "c"), ordered = TRUE)
unique_or_na(f)
unique_or_na(f[1:2])

x <- c("a", "b", "a")
unique_or_na(x[c(1, 3)])
unique_or_na(x)
unique_or_na(x) \%>\% typeof()
}
\author{
Michael R. McLaren (orcid: \href{https://orcid.org/0000-0003-1575-473X}{0000-0003-1575-473X})
}
