% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellanous.R
\name{count_seq}
\alias{count_seq}
\title{Count sequences in fasta or fastq file}
\usage{
count_seq(file_path = NULL, folder_path = NULL, pattern = NULL)
}
\arguments{
\item{file_path}{The path to a  fasta, fastq or fastq.gz file}

\item{folder_path}{The path to a folder with fasta, fastq or fastq.gz files}

\item{pattern}{A pattern to filter files in a folder. E.g. \emph{R2}}
}
\value{
the number of sequences
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Use grep to count the number of line with only one '+' (fastq, fastq.gz)
or lines starting with a '>' (fasta) to count sequences.
}
\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "windows") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
count_seq(file_path = system.file(
  "extdata",
  "ex.fasta",
  package = "MiscMetabar",
  mustWork = TRUE
))
count_seq(
  folder_path = system.file("extdata", package = "MiscMetabar"),
  pattern = "*.fasta"
)
\dontshow{\}) # examplesIf}
}
\author{
Adrien Taudière
}
