% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcConnectivity.R
\name{calcTransition}
\alias{calcTransition}
\alias{calcPsi}
\title{Calculate psi (transition probabilities between sites in two phases of the
annual cycle)}
\usage{
calcTransition(
  banded = NULL,
  reencountered = NULL,
  counts = NULL,
  originAssignment = NULL,
  targetAssignment = NULL,
  originNames = NULL,
  targetNames = NULL,
  method = "SANN"
)

calcPsi(
  banded = NULL,
  reencountered = NULL,
  counts = NULL,
  originAssignment = NULL,
  targetAssignment = NULL,
  originNames = NULL,
  targetNames = NULL,
  method = "SANN"
)
}
\arguments{
\item{banded}{For band return data, a vector of the number of released
animals from each origin site (including those never reencountered
in a target region)}

\item{reencountered}{For band return data, a matrix with B rows and W
columns. Number of animals reencountered
on each target site by origin site they came from}

\item{counts}{Migration data without target-region detection heterogeneity
(i.e., anything but band return data) can be entered one of two ways: either
here or with \code{originAssignment} and \code{targetAssignment}. If here, a
matrix with B rows and W columns with counts of animals observed in each
combination of origin and target site}

\item{originAssignment}{Assignment of animals (not including band return
data) to origin season sites. A vector of integers (1-B) with length number
of animals tracked. Note that these data can either be entered using this
argument and \code{targetAssignment} or using \code{counts}, but not both}

\item{targetAssignment}{Assignment of animals (not including band return
data) to target season sites. A vector of integers (1-W) with length number
of animals tracked. Note that these data can either be entered using this
argument and \code{originAssignment} or using \code{counts}, but not both}

\item{originNames}{Optional, but recommended to keep track. Vector of names
for the origin sites. If not provided, the function will either try to get
these from another input or provide default names (capital letters)}

\item{targetNames}{Optional, but recommended to keep track. Vector of names
for the target sites. If not provided, the function will either try to get
these from another input or provide default names (numbers)}

\item{method}{See \code{optim}. "SANN" is slow but reasonably accurate.
"Nelder-Mead" is fast but not accurate here. "BFGS" is also fast but not
very stable here}
}
\value{
\code{calcTransition} returns a list with the element(s):
\describe{
  \item{\code{psi}}{Matrix with point estimate of transition probabilities}
  \item{\code{r}}{Vector containing point estimate of reencounter
   probabilities at each target site. Not included unless data includes
   band reencounters}
}
}
\description{
Provides simple maximum-likelihood point estimate of transition probabilities
that does not include measures of uncertainty. Incorporates detection
heterogeneity where appropriate (band/ring return data), but not location
uncertainty. Shared primarily for testing; use of \code{\link{estTransition}}
is recommended instead.
}
\examples{
nOriginSites <- 4
nTargetSites <- 4
originNames <- LETTERS[1:nOriginSites]
targetNames <- 1:nTargetSites
psiTrue <- array(c(0.1, 0.2, 0.3, 0.4,
                   0.2, 0.3, 0.4, 0.1,
                   0.3, 0.4, 0.1, 0.2,
                   0.4, 0.1, 0.2, 0.3),
                 c(nOriginSites, nTargetSites),
                 dimnames = list(originNames, targetNames))
rowSums(psiTrue)
rTrue <- c(0.5, 0.05, 0.3, 0.6)
banded1 <- c(500, 1000, 2000, 3000)
reencountered1 <- simCMRData(psiTrue, banded1, rTrue)$reencountered
psi_r_calc_sloppy <- calcTransition(banded = banded1,
                             reencountered = reencountered1,
                             originNames = originNames,
                             targetNames = targetNames,
                             method = "BFGS")
psi_r_calc_sloppy
\donttest{
psi_r_calc <- calcTransition(banded = banded1,
                             reencountered = reencountered1,
                             originNames = originNames,
                             targetNames = targetNames,
                             method = "SANN")
psi_r_calc
psi_r_mcmc <- estTransition(banded = banded1, reencountered = reencountered1,
                            originNames = originNames,
                            targetNames = targetNames,
                            method = "MCMC",
                            nSamples = 45000, nBurnin = 5000, #reduced for example speed
                            nThin = 1, verbose = 0)
print(psi_r_mcmc)
psi_r_boot <- estTransition(banded = banded1, reencountered = reencountered1,
                            originNames = originNames,
                            targetNames = targetNames,
                            method = "bootstrap",
                            nSamples = 200) #reduced for example speed
print(psi_r_boot)
}
}
\seealso{
\code{\link{estTransition}}, \code{\link{optim}}
}
