% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSKAT.R
\name{CSKAT}
\alias{CSKAT}
\title{Small-sample SKAT for correlated (continuous) data ('c' stands for 'correlated')}
\usage{
CSKAT(formula.H0, data = NULL, Ks, nperm = 999)
}
\arguments{
\item{formula.H0}{A two-sided linear formula object describing both the fixed-effects and random-effects part of
the model under the null, use the same syntax as the "lmer" in "lme4" package}

\item{data}{An optional data frame containing the variables named in formula. Default: NULL.}

\item{Ks}{A kernel matrix or list of kernels, quantifying the similarities between samples.}

\item{nperm}{Number of permutations for calculating the omnibus p-value. Ignored unless Ks is a list of candidate kernels.}
}
\value{
\describe{
  \item{p.value}{Association p-values}
  \item{Q.adj}{Adjusted score statistics}
}
}
\description{
Compute the adjusted score statistic and p-value
}
\examples{

Y <- rnorm(100)
Z <- matrix(rnorm(200), 100, 2)
ID <- gl(20, 5)
G <- matrix(rbinom(1000, 2, 0.05), 100, 10)
K <- G \%*\% t(G)
CSKAT(formula.H0 = Y ~ Z + (1 | ID), Ks = K)

}
\references{
Zhan X, et al. (2018) A small-sample kernel association test for correlated data with application to microbiome association studies.  
Genet Epidemiol.
}
\author{
Nehemiah Wilson, Anna Plantinga, Xiang Zhan, Jun Chen.
}
