% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviance.R
\name{deviance_poisson}
\alias{deviance_poisson}
\title{Poisson Deviance}
\usage{
deviance_poisson(actual, predicted, w = NULL, ...)
}
\arguments{
\item{actual}{Observed non-negative values.}

\item{predicted}{Strictly positive predicted values.}

\item{w}{Optional case weights.}

\item{...}{Further arguments passed to \code{weighted_mean()}.}
}
\value{
A numeric vector of length one.
}
\description{
Weighted average of unit Poisson deviance, see reference below.
Special case of Tweedie deviance with Tweedie parameter 1.
}
\examples{
deviance_poisson(0:2, c(0.1, 1, 3))
deviance_poisson(0:2, c(0.1, 1, 3), w = c(1, 1, 1))
deviance_tweedie(0:2, c(0.1, 1, 3), tweedie_p = 1)
deviance_tweedie(0:2, c(0.1, 1, 3), tweedie_p = 1.01)
deviance_poisson(0:2, c(0.1, 1, 3), w = 1:3)
}
\references{
Jorgensen, B. (1997). The Theory of Dispersion Models. Chapman & Hall/CRC. ISBN 978-0412997112.
}
\seealso{
\code{\link{deviance_tweedie}}.
}
