% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviance_bernoulli.R
\name{deviance_bernoulli}
\alias{deviance_bernoulli}
\title{Bernoulli deviance}
\usage{
deviance_bernoulli(actual, predicted, w = NULL, ...)
}
\arguments{
\item{actual}{Observed values.}

\item{predicted}{Predicted values.}

\item{w}{Optional case weights.}

\item{...}{Further arguments passed to \code{logLoss}.}
}
\value{
A numeric vector of length one.
}
\description{
Weighted average of unit Bernoulli deviance, defined as twice logLoss.
}
\examples{
deviance_bernoulli(c(0, 0, 1, 1), c(0.1, 0.1, 0.9, 0.8))
deviance_bernoulli(c(1, 0, 0, 1), c(0.1, 0.1, 0.9, 0.8))
deviance_bernoulli(c(0, 0, 1, 1), c(0.1, 0.1, 0.9, 0.8), w = 1:4)

}
\seealso{
\code{\link{logLoss}}.
}
\author{
Michael Mayer, \email{mayermichael79@gmail.com}
}
