% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_lme.R
\name{graph_lme}
\alias{graph_lme}
\title{Metric graph linear mixed effects models}
\usage{
graph_lme(
  formula,
  graph,
  model = list(type = "linearModel"),
  which_repl = NULL,
  optim_method = "L-BFGS-B",
  possible_methods = c("Nelder-Mead", "L-BFGS-B"),
  model_options = list(),
  BC = 0,
  previous_fit = NULL,
  fix_coeff = FALSE,
  parallel = FALSE,
  n_cores = parallel::detectCores() - 1,
  optim_controls = list(),
  improve_hessian = FALSE,
  hessian_args = list(),
  check_euclidean = TRUE
)
}
\arguments{
\item{formula}{Formula object describing the relation between the response
variables and the fixed effects.}

\item{graph}{A \code{metric_graph} object.}

\item{model}{The random effects model that will be used (it also includes the
option of not having any random effects). It can be either a character,
whose options are 'lm', for linear models without random effects; 'WM1' and
'WM2' for Whittle-Matern models with \eqn{\alpha}=1 and 2, with exact
precision matrices, respectively; 'WM' for Whittle-Matern models where one
also estimates the smoothness parameter via finite-element method; 'isoExp'
for a model with isotropic exponential covariance; 'GL1' and 'GL2' for a
SPDE model based on graph Laplacian with \eqn{\alpha} = 1 and 2, respectively.
'WMD1' is the directed Whittle-Matern with  \eqn{\alpha}=1.
There is also the option to provide it as a list containing the elements
\code{type}, which can be \code{linearModel}, \code{WhittleMatern}, \code{graphLaplacian} or \code{isoCov}.
\code{linearModel} corresponds to a linear model without random effects.
For \code{WhittleMatern} models, that is, if the list contains \code{type = 'WhittleMatern'},
one can choose between a finite element approximation of the precision matrix
by adding \code{fem = TRUE} to the list, or to use the exact precision matrix
(by setting \code{fem = FALSE}). If \code{fem} is \code{FALSE}, there is also the parameter
\code{alpha}, to determine the order of the SPDE, which is either 1 or 2. If \code{fem}
is \code{TRUE} and \code{alpha} is not specified, then the default value of \code{alpha=1}
will be used. If \code{fem} is \code{TRUE} and one does not specify \code{alpha}, it will be
estimated from the data. However, if one wants to have \code{alpha} fixed to some
value, the user can specify either \code{alpha} or \code{nu} in the list. See the
vignettes for examples. Finally, for type 'WhittleMatern', there is an optional
argument, \code{rspde_order}, that chooses the order of the rational approximation.
By default \code{rspde_order} is 2.
Finally, if one wants to fit a nonstationary model, then \code{fem} necessarily
needs to be \code{TRUE}, and one needs to also supply the matrices \code{B.tau}
and \code{B.kappa} or \code{B.range} and \code{B.sigma}.
For \code{graph-Laplacian} models, the list must also contain a parameter \code{alpha}
(which is 1 by default). For \code{isoCov} models, the list must
contain a parameter \code{cov_function}, containing the covariance function.
The function accepts a string input for the following covariance functions:
'exp_covariance', 'WM1', 'WM2', 'GL1', 'GL2'. For another covariance function,
the function itself must be provided as the \code{cov_function} argument. The
default is 'exp_covariance', the exponential covariance. We also have
covariance-based versions of the Whittle-Matern and graph Laplacian models,
however they are much slower, they are the following (string) values for
'cov_function': 'alpha1' and 'alpha2' for Whittle-Matern fields, and 'GL1'
and 'GL2' for graph Laplacian models. Finally, for \code{Whittle-Matern} models,
there is an additional parameter \code{version}, which can be either 1 or 2, to
tell which version of the likelihood should be used. Version is 1 by default.}

\item{which_repl}{Vector or list containing which replicates to consider in
the model. If \code{NULL} all replicates will be considered.}

\item{optim_method}{The method to be used with \code{optim} function.}

\item{possible_methods}{Which methods to try in case the optimization fails or the hessian is not positive definite. The options are 'Nelder-Mead', 'L-BFGS-B', 'BFGS', 'CG' and 'SANN'. By default only 'Nelder-Mead' and 'L-BFGS-B' are considered.}

\item{model_options}{A list containing additional options to be used in the model. Currently, it is possible to fix parameters during the estimation or change the starting values of the parameters. The general structure of the elements of the list is \code{fix_parname} and \code{start_parname}, where \code{parname} stands for the name of the parameter. If \code{fix_parname} is not \code{NULL}, then the model with be fitted with the \code{parname} being fixed at the value that was passed. If \code{start_parname} is not \code{NULL}, the model will be fitted using the value passed as starting value for \code{parname}. the For 'WM' models, the possible elements of the list are: \code{fix_sigma_e}, \code{start_sigma_e}, \code{fix_nu}, \code{start_nu}, \code{fix_sigma}, \code{start_sigma}, \code{fix_range}, \code{start_range}. Alternatively, one can use \code{fix_sigma_e}, \code{start_sigma_e}, \code{fix_nu}, \code{start_nu}, \code{fix_tau}, \code{start_tau}, \code{fix_kappa}, \code{start_kappa}. For 'WM1', 'WM2', 'isoExp', 'GL1' and 'GL2' models, the possible elements of the list are \code{fix_sigma_e}, \code{start_sigma_e}, \code{fix_sigma}, \code{start_sigma}, \code{fix_range}, \code{start_range}. Alternatively, one can use \code{fix_sigma_e}, \code{start_sigma_e}, \code{fix_tau}, \code{start_tau}, \code{fix_kappa}, \code{start_kappa}. For 'isoCov' models, the possible values are \code{fix_sigma_e}, \code{start_sigma_e}, \code{fix_par_vec}, \code{start_par_vec}. Observe that contrary to the other models, for 'isoCov' models, both \code{fix_par_vec} and \code{start_par_vec} should be given as vectors of the size of the dimension of the vector for the input of the covariance function passed to the 'isoCov' model. Furthermore, for 'isoCov' models, \code{fix_par_vec} is a logical vector, indicating which parameters to be fixed, and the values will be kept fixed to the values given to \code{start_par_vec}, one can also use \code{fix_sigma_e} and \code{start_sigma_e} for controlling the std. deviation of the measurement error.}

\item{BC}{For \code{WhittleMatern} models, decides which boundary condition to use
(0,1). Here, 0 is Neumann boundary conditions and 1 specifies stationary boundary
conditions.}

\item{previous_fit}{An object of class \code{graph_lme}. Use the fitted coefficients as starting values.}

\item{fix_coeff}{If using a previous fit, should all coefficients be fixed at the starting values?}

\item{parallel}{logical. Indicating whether to use \code{optimParallel()} or not.}

\item{n_cores}{Number of cores to be used if parallel is true.}

\item{optim_controls}{Additional controls to be passed to \code{optim()} or \code{optimParallel()}.}

\item{improve_hessian}{Should a more precise estimate of the hessian be obtained?
Turning on might increase the overall time.}

\item{hessian_args}{List of controls to be used if \code{improve_hessian} is \code{TRUE}.
The list can contain the arguments to be passed to the \code{method.args} argument
in the \code{hessian} function. See the help of the \code{hessian} function in 'numDeriv'
package for details. Observet that it only accepts the "Richardson" method for
now, the method "complex" is not supported.}

\item{check_euclidean}{Check if the graph used to compute the resistance distance has Euclidean edges? The graph used to compute the resistance distance has the observation locations as vertices.}
}
\value{
A list containing the fitted model.
}
\description{
Fitting linear mixed effects model in metric graphs. The random effects can be
Gaussian Whittle-Matern fields, discrete Gaussian Markov random fields based
on the graph Laplacian, as well as Gaussian random fields with isotropic
covariance functions.
}
