% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basics.R
\name{MetaculR_questions}
\alias{MetaculR_questions}
\title{Retrieve questions from Metaculus API}
\usage{
MetaculR_questions(
  api_domain = "www",
  order_by = "last_prediction_time",
  status = "all",
  search = "",
  guessed_by = "",
  offset = 0,
  pages = 10
)
}
\arguments{
\item{api_domain}{Use "www" unless you have a custom Metaculus domain}

\item{order_by}{Choose "last_prediction_time", "-activity", "-votes", "-publish_time", "close_time", "resolve_time", "last_prediction_time"}

\item{status}{Choose "all", "upcoming", "open", "closed", "resolved"}

\item{search}{Search term(s)}

\item{guessed_by}{Generally your Metaculus_user_id}

\item{offset}{Question offset}

\item{pages}{Number of pages to request}
}
\value{
A list of questions, ordered by last prediction time.
}
\description{
Retrieve questions from Metaculus API
}
\examples{
\dontrun{
questions_recent_open <-
  MetaculR_questions(
    order_by = "close_time",
    status = "open",
    guessed_by = "")
}
}
\seealso{
Other Question Retrieval functions: 
\code{\link{MetaculR_myPredictions_Resolved}()},
\code{\link{MetaculR_myPredictions}()}
}
\concept{Question Retrieval functions}
