### Name: koplsPredict
### Title: Prediction of new samples from a K-OPLS model
### Aliases: koplsPredict
### Keywords: multivariate

### ** Examples


## Load data set
data(koplsExample)

## Define kernel function parameter
sigma<-25

## Define number of Y-orthogonal components
nox<-3

## Construct kernels
Ktr<-koplsKernel(Xtr,NULL,'g',sigma)
KteTr<-koplsKernel(Xte,Xtr,'g',sigma)
KteTe<-koplsKernel(Xte,NULL,'g',sigma)

## Model 
model<-koplsModel(Ktr,Ytr,1,nox,'mc','mc');

## Predict
modelPred<-koplsPredict(KteTr,KteTe,Ktr,model,rescaleY=TRUE)

## Visualize
plot(modelPred$Yhat, Yte, xlab="Predicted", ylab="Observed")
abline(v=0.5, col="Red", lty=2) ## Approximate decision boundary




