% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms-class.R
\docType{class}
\name{ms-class}
\alias{ms-class}
\alias{ms}
\alias{show,ms-method}
\alias{summary,ms-method}
\alias{plot,ms,ANY-method}
\title{The ms Class.}
\usage{
\S4method{show}{ms}(object)

\S4method{summary}{ms}(object)

\S4method{plot}{ms,ANY}(x, y, ...)
}
\arguments{
\item{object}{A ms class object}

\item{x}{A ms class object}

\item{y}{missing}

\item{...}{The usual extra arguments to generic functions — see \code{\link[graphics]{plot}}, \code{\link[graphics]{plot.default}}}
}
\description{
Class of object returned by function \code{\link[MetabolicSurv]{MSpecificCoxPh}}.
}
\details{
plot {signature(x = "ms"): Plots for ms class analysis results}
signature(x = "ms"): Plots for ms class analysis results.

Any parameters of \code{\link[graphics]{plot.default}} may be passed on to this particular plot method.

show(ms-object)
}
\section{Slots}{

\describe{
\item{\code{Result}}{A list of dataframes of each output object of coxph for the metabolites.}

\item{\code{HRRG}}{A dataframe with estimated metabolite-specific HR for low risk group and 95 percent CI.}

\item{\code{Group}}{A matrix of the classification group a subject belongs to for each of the metabolite analysis. The metabolites are on the rows and the subjects are the columns}

\item{\code{Metnames}}{The names of the metabolites for the analysis}
}}

\examples{
## GENERATE SOME METABOLIC SURVIVAL DATA WITH PROGNOSTIC FACTORS
Data<-MSData(nPatients=100,nMet=150,Prop=0.5)

## DO THE METABOLITE BY METABOLITE ANALYSIS
Eg = MSpecificCoxPh(Survival=Data$Survival, Mdata=t(Data$Mdata),
Censor=Data$Censor, Reduce = FALSE, Select = 15,
Prognostic=Data$Prognostic, Quantile = 0.5)

## GET THE CLASS OF THE OBJECT
class(Eg)     # An "ms" Class

##  METHOD THAT CAN BE USED FOR THIS CLASS
show(Eg)
summary(Eg)
plot(Eg)
}
\seealso{
\code{\link[MetabolicSurv]{MSpecificCoxPh}}
}
\author{
Olajumoke Evangelina Owokotomo, \email{olajumoke.owokotomo@uhasselt.be}

Ziv Shkedy
}
