% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/immunoStates.R
\name{immunoStatesGenePropCorr}
\alias{immunoStatesGenePropCorr}
\title{Correct gene expression using cell proportions from immunoStates}
\usage{
immunoStatesGenePropCorr(metaObject)
}
\arguments{
\item{metaObject}{a MetaIntegrator formatted Meta object.}
}
\value{
Results from immunoStates gene proportion correction on the MetaIntegrator 
   object are stored in $iScorrExp of the original Meta object
}
\description{
Correct gene expression using cell proportions from immunoStates
}
\examples{
\dontrun{
# Example won't work on tinyMetaObject because it requires real gene names
# Download the needed datasets for processing. 
sleData <- getGEOData(c("GSE11909","GSE50635", "GSE39088"))

# Run immunoStates
immunoStatesCorrected <- immunoStateGenePropCorr(sleData)
}
}
\author{
Francesco Vallania
copyright by Francesco Vallania
}
