% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mr_allmethods-methods.R
\docType{methods}
\name{mr_allmethods}
\alias{mr_allmethods}
\alias{mr_allmethods,MRInput-method}
\title{Mendelian randomization estimation using all methods}
\usage{
mr_allmethods(object, method = "all", ...)

\S4method{mr_allmethods}{MRInput}(object, method = "all", ...)
}
\arguments{
\item{object}{An \code{MRInput} object.}

\item{method}{Which estimation method should be included in the calculation. By default, all estimates are computed (\code{"all"}), but one can choose to show only the results of median-based, inverse-variance weighted, or MR-Egger methods separately through specifying \code{"median"}, \code{"ivw"}, \code{"egger"}, or \code{"main"} (gives main results only, that is simple and weighted median, IVW, and MR-Egger).}

\item{...}{Additional arguments to be passed to other methods.}
}
\value{
An object of type \code{MRAll} with the following slots :

 \item{Data}{The MRInput object used to calculate the various values.}
 \item{Values}{A data.frame containing the various estimates.}
 \item{Method}{The choice of methods estimated (default is \code{"all"}).}
}
\description{
The function \code{mr_allmethods} implements Mendelian randomization analyses using summarized data to calculate estimates (as well as standard
errors and confidence interval limits) for all the methods included in the package (or alternatively for the group of methods chosen).
}
\details{
See \code{mr_median}, \code{mr_egger}, and \code{mr_ivw} for details of how each of the methods is implemented.
}
\examples{
mr_allmethods(mr_input(bx = ldlc, bxse = ldlcse, 
  by = chdlodds, byse = chdloddsse), method="all", iterations = 1000)
  # iterations is set to 1000 to reduce runtime for the mr_median method,
  # at least 10000 iterations are recommended in practice
mr_allmethods(mr_input(bx = ldlc, bxse = ldlcse,
  by = chdlodds, byse = chdloddsse), method="ivw")
mr_allmethods(mr_input(bx = ldlc, bxse = ldlcse,
  by = chdlodds, byse = chdloddsse), method="egger")
mr_allmethods(mr_input(bx = ldlc, bxse = ldlcse,
  by = chdlodds, byse = chdloddsse), method="median", iterations = 1000)
mr_allmethods(mr_input(bx = ldlc, bxse = ldlcse,
  by = chdlodds, byse = chdloddsse), method="main", iterations = 1000)

}
\references{
See \code{mr_median}, \code{mr_egger}, and \code{mr_ivw}.
}

