% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2famskatrc.R
\name{Mega2famSKATRC}
\alias{Mega2famSKATRC}
\title{execute the CRAN famSKAT_RC function on a subset of the gene transcripts}
\usage{
Mega2famSKATRC(gs = 1:100, genes = NULL, envir = ENV, ...)
}
\arguments{
\item{gs}{a subrange of the default transcripts (refRanges) over which to calculate
the \emph{DOfamSKATRC} function.}

\item{genes}{a list of genes over which to calculate the \emph{DOfamSKATRC} function.
The value, "*", means use all the transcripts in the selected Bioconductor database.
If genes is NULL, the gs range of the internal \emph{refRanges} will be used.}

\item{envir}{'environment' containing SQLite database and other globals.}

\item{...}{extra arguments that are acceptable to famSKAT_RC.  These are listed with the
\code{\link{DOfamSKATRC}} function.}
}
\value{
The data frame with the results is stored in the environment and named \emph{famSKATRC_results},
 viz. envir$famSKATRC_results
}
\description{
If the \emph{gene} argument is NULL, execute the famSKAT_RC function on the first \emph{gs}
 gene transcripts (default is gs = 1:100).
 Update the \emph{envir$famSKATRC_results} data frame with the results.
 Otherwise, \emph{gene} is a string vector of genes to process.  The special value '*' stands
 for all the known genes.
}
\note{
A helper function
 \code{SKAT3arg} is defined for the 3 argument callback function which in turn calls
 \code{DOfamSKATRC} with the appropriate arguments (including those specific to the
 \code{Mega2famSKATRC} function).
}
\examples{
db = system.file("exdata", "seqsimm.db", package="Mega2R")
ENV = init_famSKATRC(db, verbose = FALSE)
ENV$verbose = FALSE
ENV$famSKATRC_results = ENV$famSKATRC_results[0, ]
Mega2famSKATRC(gs=50:60, envir=ENV, pheno=3)

\donttest{
# donttestcheck: try this below if there is time
 Mega2famSKATRC(genes=c("CEP104"), envir=ENV, pheno=3 )
}

ENV$famSKATRC_results

}
\seealso{
\code{\link{init_famSKATRC}}, \code{\link{DOfamSKATRC}}
}
