% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2riterate.R
\name{mkfam}
\alias{mkfam}
\title{assemble pedigree information into a data frame}
\usage{
mkfam(brkloop = FALSE, traitname = "default", envir = ENV)
}
\arguments{
\item{brkloop}{I haven't needed to set this TRUE yet.  Maybe never will.
If loops are broken, a person will be replaced by a dopple ganger in the same family with a
different father/mother.  The number of persons per family will be different when there
are broken loops.  Also, the person_link numbers will be different for all the persons after
the first loop is broken.}

\item{traitname}{Name of the trait to use as case/control value; by default, "default"}

\item{envir}{An 'environment' that contains all the data frames created from the SQLite database.}
}
\value{
data frame
that is described above
}
\description{
Generate a data frame with a row for each person.  The observations are:
\tabular{ll}{
\strong{pedigree} \tab family pedigree name\cr
\strong{person} \tab person name\cr
\strong{father} \tab father of person\cr
\strong{mother} \tab mother of person\cr
\strong{sex} \tab sex of person\cr
\strong{trait} \tab value of case/control phenotype for person
}
}
\note{
The columns of this data frame come by selecting the values after merging the data frames: \emph{pedigree_table}, \emph{person_table}, and \emph{trait_table}.

Also, the father and mother columns from \emph{person_table} are translated from the row index in the
\emph{person_table} to the corresponding name.

This function stores the data frame in the 'environment' and also returns it.
 The function \code{setfam()} stores the data frame
 into the 'environment' and adjusts the \emph{genotype_table} and the \emph{phenotype_table}.
}
\examples{
db = system.file("exdata", "seqsimm.db", package="Mega2R")
ENV = read.Mega2DB(db)

fam = mkfam()

fam

}
