% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2rcreate.R
\name{mkMarkers}
\alias{mkMarkers}
\title{create "markers" data frame}
\usage{
mkMarkers(bpPosMap = 1, envir = ENV)
}
\arguments{
\item{bpPosMap}{An integer that indicates the map (index) to use to merge the
chromosome/position fields from the map_table data frame to the marker_table data frame.
See showMapNames() for the string name to index mapping.}

\item{envir}{an environment that contains all the data frames created from the SQLite database.}
}
\value{
None
}
\description{
Create the markers data frame.  It contains 5
observations: \describe{
  \item{locus_link:}{locus offset of this marker}
  \item{locus_link_fill:}{locus offset plus an accumulating fudge factor that jumps
         with each new chromosome because the count of markers per chromosome is force to be
         a multiple of 4.  (This value corresponds to the offset of the marker in the
         \code{unified_genotype_table}.)}
  \item{MarkerName:}{name of the marker}
  \item{chromosome:}{chromosome number of the marker}
  \item{position:}{base pair position of the marker (selected by bpPosMap[below])}
      }
}
\details{
Select a map (index) from the map_table to merge with the select marker_table
 data frame to make the marker data frame.  See showMapNames() for the string name to index mapping.
}
\examples{
db = system.file("exdata", "seqsimm.db", package="Mega2R")
ENV = read.Mega2DB(db, verbose = FALSE)

mkMarkers(1)

ENV$markers

}
