% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2skat.R
\name{init_SKAT}
\alias{init_SKAT}
\title{load Mega2 SQLite database and perform initialization for SKAT usage}
\usage{
init_SKAT(db = NULL, verbose = FALSE, allMarkers = FALSE)
}
\arguments{
\item{db}{specifies the path of a \bold{Mega2} SQLite database containing study data.}

\item{verbose}{TRUE indicates that diagnostic printouts should be enabled.
This value is saved in the returned environment.}

\item{allMarkers}{TRUE means use all markers in a given transcript even if there is no
variation.  FALSE means ignore markers that show no variation; this is the default.}
}
\value{
"environment" containing data frames from an SQLite database and some computed values.
}
\description{
This populates the \bold{R} data frames from the specified \bold{Mega2} SQLite database.  It then
 prunes the samples to only include members that have a definite case or control
 status.  Undefined samples are ignored.
}
\note{
\emph{init_SKAT} creats a data frame, \emph{envir$phe}, of phenotype observations.
 In addition, it initializes a matrix to aid
  in translating a genotype allele matrix to a genotype count matrix.

 It also initializes the data frame \emph{envir$SKAT_results} to zero rows.
}
\examples{
db = system.file("exdata", "seqsimm.db", package="Mega2R")
ENV = init_SKAT(db, verbose = FALSE, allMarkers = FALSE)
ls(ENV)

}
\seealso{
\code{\link{Mega2SKAT}}
}
