% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2riterate.R
\name{setAnnotations}
\alias{setAnnotations}
\title{set default name of transcription database and name of database mapping gene name to entrez gene id}
\usage{
setAnnotations(txdb, entrezGene, envir = ENV)
}
\arguments{
\item{txdb}{name of Bioconductor transcription database.}

\item{entrezGene}{name of Bioconductor mapping of gene name or gene alias to entrez gene id}

\item{envir}{an 'environment' that contains all the data frames created from the SQLite database.}
}
\value{
None
}
\description{
This function takes two string parameters:
  one to specify entrez gene ids to transcripts,
  the other to map gene names to entrez gene id's.
}
\note{
\bold{Mega2R} will take care to load the necessary databases, but you will have to
 install them from Bioconductor.  This is explained at length in the package Vignette.
}
\examples{
db = system.file("exdata", "seqsimm.db", package="Mega2R")
ENV = read.Mega2DB(db)

setAnnotations("TxDb.Hsapiens.UCSC.hg19.knownGene", "org.Hs.eg.db")

ENV$txdb
ENV$entrezGene

}
