\name{ADPopSelExample2}
\alias{ADPopSelExample2}
\title{
Simulation-based design of an adaptive trial with population selection (binary endpoint)
}
\description{
Consider a seamless Phase II/Phase III or Phase III trial with a binary primary efficacy endpoint with a higher proportion indicating a more favorable outcome. The efficacy and safety profiles of a single dose or regimen of an experimental treatment will be evaluated versus a control in two patient populations (overall population and biomarker-positive population). An adaptive design with two interim analyses will be used in the trial (the first interim analysis may correspond to the end of the Phase II portion of the trial) to support the following decision rules:
\itemize{
	\item Futility stopping rule will be applied at the first interim analysis (IA1). The trial will be terminated for futility if the predicted probability of success (conditional power) in the overall population is too low
    \item Population selection rule will be applied at the second interim analysis (IA2). The most promising population or populations will be selected for the final analysis (FA).
} 
The following design parameters will be assumed:
\itemize{
    \item A balanced design with 120 enrolled patients per arm will be utilized in this trial.
    \item The prevalence of biomarker-positive patients in the overall population is expected to be 40\%.    
    \item The patient dropout rate at the end of the treatment period is equal to 15\%.
    \item The information fractions at IA1 and IA2 are set to 40\% and 60\%, i.e., the first and second interim looks will be taken after 40\% and 60\% of the patients complete the treatment period or drop out of the trial before completing the treatment period. 
}
In addition, the following decision rules will be considered at the two interim analyses:
\itemize{
    \item The futility threshold at IA1 is set to 20\%.
    \item The influence and interaction thresholds used in the population selection rule are set to 0.1 and 1.3. The conditions based on these thresholds are applied sequentially to determine if the final analysis should be performed in the overall population only, in the biomarker-positive population only or simultaneously in both populations. 
}
The treatment effect assumptions are specified within the biomarker-positive and biomarker-negative populations. A common effect will be assumed in the control arm, i.e., the response rate of 10\% regardless of the biomarker status, and a strong differential treatment effect will be considered. Specifically, a fairly weak response rate of 25\% will be assumed in patients with a biomarker-negative status and a much stronger effect with a response rate of 40\% in patients with a biomarker-positive status. 

Key operating characteristics of the proposed adaptive design with population selection will be evaluated using the \code{\link{ADPopSel}} function based on 10,000 simulation runs. To invoke this function, a list of all design and decision rule parameters (\code{parameters}) needs to be created as shown below. A comprehensive simulation report for this adaptive design can be generated by calling the \code{\link{GenerateReport}} function and a graphical user interface can be launched using the \code{\link{ADPopSelApp}} function.
}
\arguments{No arguments}
\value{No return value}
\seealso{
  \code{\link{ADPopSel}}, \code{\link{ADPopSelExample1}}, \code{\link{ADPopSelExample3}}
}
\examples{
# List of all parameters
parameters = list()

# Endpoint type
parameters$endpoint_type = "Binary"

# Direction of favorable outcome
parameters$direction = "Higher"

# Number of enrolled patients (control, treatment) 
parameters$sample_size = c(120, 120)

# Prevalence of biomarker-positive patients in the overall population
parameters$prevalence = 0.4

# Patient dropout rate
parameters$dropout_rate = 0.15

# Response rate in the control arm (biomarker-negative, biomarker-positive)
parameters$control_rate = c(0.1, 0.1)

# Response rate in the treatment arm (biomarker-negative, biomarker-positive)
parameters$treatment_rate = c(0.25, 0.4)

# Information fractions at IA1, IA2, FA
parameters$info_frac = c(0.4, 0.6, 1)

# Futility threshold for conditional power at IA1
parameters$futility_threshold = 0.2

# Influence threshold at IA2
parameters$influence = 0.1

# Interaction threshold at IA2
parameters$interaction = 1.3

# One-sided alpha level
parameters$alpha = 0.025

# Number of simulations
parameters$nsims = 1000

# Run simulations to compute key characteristics
results = ADPopSel(parameters)

# Generate a simulation report (remove tempfile)
GenerateReport(results, 
              tempfile("ADPopSel Binary endpoint.docx", fileext=".docx"))
}