% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{Carmel_Valley}
\alias{Carmel_Valley}
\title{Carmel Valley example dataset}
\format{
An \emph{mts} object with 600 rows and 2 columns of data.
}
\usage{
Carmel_Valley
}
\description{
The \code{Carmel_Valley} dataset provides a quickly loadable
version of a single-sensor \emph{mts_monitor} object for practicing and code
examples.
}
\details{
In August of 2016, the Soberanes fire in California burned along the Big Sur
coast. It was at the time the most expensive wildfire in US history. This
dataset contains PM2.5 monitoring data for the monitor in Carmel Valley which
shows heavy smoke as well as strong diurnal cycles associated with sea
breezes. Data are stored as an \emph{mts} object and are used in some
examples in the package documentation.

This dataset was generated on 2021-10-14 by running:

\preformatted{
library(AirMonitor)

Carmel_Valley <-
  epa_aqs_loadAnnual(
    year = 2016,
    parameterCode = 88101,
    archiveBaseUrl = NULL,
    archiveBaseDir = "~/Data/monitoring"
  ) \%>\%
  monitor_filterMeta(deviceDeploymentID == "a9572a904a4ed46d_060530002_03") \%>\%
  monitor_filterDate(20160722, 20160815)

save(Carmel_Valley, file = "data/Carmel_Valley.rda")
}
}
\keyword{datasets}
