% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mazama_initialize.R
\name{mazama_initialize}
\alias{mazama_initialize}
\title{Initialize with MazamaScience standard directories}
\usage{
mazama_initialize(spatialDataDir = "~/Data/Spatial")
}
\arguments{
\item{spatialDataDir}{Directory where spatial datasets are found,
Default: "~/Data/Spatial"}
}
\value{
No return value.
}
\description{
Convenience function to initialize spatial data for US state
and county maps. Wraps the following setup lines:

\preformatted{
MazamaSpatialUtils::setSpatialDataDir(spatialDataDir)

MazamaSpatialUtils::loadSpatialData("USCensusCounties_02")
MazamaSpatialUtils::loadSpatialData("USCensusStates_02")
}
}
\examples{
\donttest{
library(MazamaSpatialPlots)

# Set up directory for spatial data
spatialDataDir <- tempdir() # typically "~/Data/Spatial"
MazamaSpatialUtils::setSpatialDataDir(spatialDataDir)

exists("USCensusStates_02")
mazama_initialize(spatialDataDir)
exists("USCensusStates_02")
class(USCensusStates_02)
}
}
