% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location_getOpenCageInfo.R
\name{location_getOpenCageInfo}
\alias{location_getOpenCageInfo}
\title{Get location information from OpenCage}
\usage{
location_getOpenCageInfo(longitude = NULL, latitude = NULL, verbose = FALSE)
}
\arguments{
\item{longitude}{Single longitude in decimal degrees E.}

\item{latitude}{Single latitude in decimal degrees N.}

\item{verbose}{Logical controlling the generation of progress messages.}
}
\value{
Single-row tibble with OpenCage information.
}
\description{
The OpenCage reverse geocoding service is used to obtain all
available information for a specific location.

The data from OpenCage should be considered to be the gold standard for address
information could and should be used to override information we get elsewhere.
}
\note{
The OpenCage service requires an API key which can be obtained from
their web site. This API key must be set as an environment variable with:

\preformatted{
Sys.setenv("OPENCAGE_KEY" = "<your api key>")
}

The OpenCage "free trial" level allows for 1 request/sec and a maximum of
2500 requests per day.
}
\examples{
\donttest{
library(MazamaLocationUtils)

# Fail gracefully if any resources are not available
try({

  Sys.setenv("OPENCAGE_KEY" = "<YOUR_KEY>")

  # Wenatchee
  lon <- -120.325278
  lat <- 47.423333

  openCageTbl <- location_getOpenCageInfo(lon, lat)
  dplyr::glimpse(openCageTbl)
  
}, silent = FALSE)
}

}
\references{
\url{https://opencagedata.com}
}
