% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete.R
\name{complete}
\alias{complete}
\alias{complete.mimids}
\alias{complete.wimids}
\title{Extracts Imputed Datasets}
\usage{
\method{complete}{mimids}(data, action = 1, include = FALSE, mild = FALSE, all = TRUE, ...)

\method{complete}{wimids}(data, action = 1, include = FALSE, mild = FALSE, all = TRUE, ...)
}
\arguments{
\item{data}{A \code{mimids} or \code{wimids} object.}

\item{action}{The imputed dataset number, intended to extract its data, or an action. The input must be a positive integer or a keyword. The keywords include \code{"all"} (produces a \code{mild} object of the imputed datasets), \code{"long"} (produces a dataset with imputed datasets stacked vertically), and \code{"broad"} (produces a dataset with imputed datasets stacked horizontally). The default is \code{1}.}

\item{include}{Whether the original data with the missing values should be included. The input must be a logical value. The default is \code{FALSE}.}

\item{mild}{Whether the return value should be an object of \code{mild} class. Please note that setting \code{mild = TRUE} overrides \code{action} keywords \code{"long"}, \code{"broad"}, and \code{"repeated"}. The default is \code{FALSE}.}

\item{all}{Whether to include observations with a zero estimated weight. The default is \code{TRUE}.}

\item{...}{Ignored.}
}
\value{
This function returns the imputed dataset within the supplied \code{mimids} or \code{wimids} objects.
}
\description{
\code{complete()} function extracts data from an object of the \code{mimids} or \code{wimids} class.
}
\details{
\code{complete()} works by running \code{\link[mice:complete]{mice::complete()}} on the \code{mids} object stored within the \code{mimids} or \code{wimids} object and appending the outputs of the matching or weighting procedure. For \code{mimids} objects, the appended outputs include the matching weights, the propensity score (if included), pair membership (if included), and whether each unit was discarded. For \code{wimids} objects, the appended output is the estimated weights.
}
\examples{
\donttest{#Loading libraries
library(MatchThem)

#Loading the dataset
data(osteoarthritis)

#Multiply imputing the missing values
imputed.datasets <- mice::mice(osteoarthritis, m = 5)

#Matching the multiply imputed datasets
matched.datasets <- matchthem(OSP ~ AGE + SEX + BMI + RAC + SMK,
                              imputed.datasets,
                              approach = 'within',
                              method = 'nearest')

#Extracting the first imputed dataset
matched.dataset.1 <- complete(matched.datasets, n = 1)}
}
\references{
Stef van Buuren and Karin Groothuis-Oudshoorn (2011). \code{mice}: Multivariate Imputation by Chained Equations in \code{R}. \emph{Journal of Statistical Software}, 45(3): 1-67. \url{https://www.jstatsoft.org/v45/i03/}
}
\seealso{
\code{\link[=mimids]{mimids}}

\code{\link[=wimids]{wimids}}

\code{\link[mice:complete]{mice::complete}}
}
