% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardized_mean_difference.R
\name{compute_sub_smd}
\alias{compute_sub_smd}
\alias{sub_SMD}
\title{Compute standardized mean differences for subclassification result}
\usage{
compute_sub_smd(mi_obj = NULL, sd = "pooled")
}
\arguments{
\item{mi_obj}{A matchit object derived from MatchIt pacakge}

\item{sd}{The standard deviation used as the denominator in the formula}
}
\value{
Return a scalar (the overall SMD)
}
\description{
This function accepts a MatchIt object (i.e., the result of matchit function)
, and calculates the overall standardized mean difference after
subclassification. Note only subclassification result is applicable to this
function. For other matching results except for exact matching,
use compute_smd() instead. In addition, SMD can be calculated on the basis of
the standard deviation of original treatment group, which is the formula
used in matchit function, or on the basis of the simple pooled standard
deviation of original treatment and control group. The default is sd =
"pooled", but it can be switched to "treatment".
}
\examples{
# take lalonde data as an example
# run matchit() to obtain the matching result
 m_out <- MatchIt::matchit(treat ~ re74 + re75 + age + educ + hispan +
   black, data = MatchIt::lalonde, method = "subclass", subclass = 7)
 compute_sub_smd(m_out, sd = "treatment")
}
\references{
Austin, P. C. (2011). An Introduction to Propensity Score Methods
for Reducing the Effects of Confounding in Observational Studies.
\emph{Multivariate Behavioral Research, 46}(3), 399-424.
https://doi.org/10.1080/00273171.2011.568786

Ho, D. E., Imai, K., King, G., & Stuart, E. A. (2011). MatchIt:
Nonparametric Preprocessing for Parametric Causal Inference. \emph{Journal
of Statistical Software, 42}(8). https://doi.org/10.18637/jss.v042.i08
}
\seealso{
compute_smd()
}
\keyword{SMD}
\keyword{subclassification}
