% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with.wimids.R
\name{with.wimids}
\alias{with.wimids}
\title{Evaluates an Expression in Weighted Imputed Datasets}
\usage{
\method{with}{wimids}(data, expr, ...)
}
\arguments{
\item{data}{This argument specifies an object of the \code{wimids} class, typically produced by a previous call to the function \code{weightitmice()}.}

\item{expr}{This argument specifies an expression of the usual syntax of R formula. See \code{help(formula)} for details.}

\item{...}{Additional arguments to be passed to \code{expr}.}
}
\value{
This function returns an object of the \code{mira} class (multiply imputed repeated analyses).
}
\description{
The \code{with()} function performs a computation on each of the \code{m} imputed datasets. The typical sequence of steps to estimate weights of observations of the imputed datasets are:
\enumerate{
 \item Impute the missing data points by the \code{mice} function (from the \pkg{mice} package), resulting in a multiple imputed dataset (an object of the \code{mids} class);
 \item Estimate weights of observations in the imputed datasets by the \code{weightitmice()} function, resulting in an object of the \code{wimids} class;
 \item Fit the model of interest (scientific model) on each weighted dataset by the \code{with()} function, resulting in an object of the \code{mira} class;
 \item Pool the estimates from each model into a single set of estimates and standard errors, resulting in an object of the \code{mipo} class.
}
}
\details{
The \code{with()} performs a computation on each of the imputed datasets.
}
\examples{
\donttest{
#Loading the 'dt.osa' dataset
data(dt.osa)

#Imputing missing data points in the'dt.osa' dataset
datasets <- mice(dt.osa, m = 5, maxit = 1,
                 method = c("", "", "mean", "", "polyreg", "logreg", "logreg"))

#Weighting the imputed datasets, 'datasets'
weighteddatasets <- weightitmice(KOA ~ SEX + AGE + SMK, datasets,
                                 approach = 'within', method = 'nearest')

#Merging the dataframe, 'dt.osp', with each imputed dataset of the 'weighteddatasets' object
weighteddatasets <- mergeitmice(weighteddatasets, dt.osp, by = "IDN")

#Analyzing the imputed datasets
models <- with(data = weighteddatasets,
               exp = glm(KOA ~ PTH, weights = inverse.weights,
                         na.action = na.omit, family = binomial))
}
}
\references{
Stef van Buuren and Karin Groothuis-Oudshoorn (2011). \code{mice}: Multivariate Imputation by Chained Equations in \code{R}. \emph{Journal of Statistical Software}, 45(3): 1-67. \url{https://www.jstatsoft.org/v45/i03/}
}
\seealso{
\code{\link[=weightitmice]{weightitmice}}
}
\author{
Extracted from the \pkg{mice} package written by Stef van Buuren et al. with few changes
}
\keyword{function}
