% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binditmice.R
\name{binditmice}
\alias{binditmice}
\title{Binds Imputed Datasets and Dataframes}
\usage{
binditmice(datasets, data)
}
\arguments{
\item{datasets}{This argument specifies an object of the \code{mids}, \code{mimids}, or \code{wimids} class.}

\item{data}{This argument specifies a dataframe.}
}
\value{
This function returns an object of the \code{mids}, \code{mimids}, or \code{wimids} class after binding a dataframe to each imputed dataset of the inputted object.
}
\description{
The \code{binditmice()} function binds a dataframe to each imputed dataset of the \code{mids}, \code{mimids}, or \code{wimids} class objects in a row-wise fashion.
}
\details{
This functions can be used instead of the \code{cbind()} function (from the \pkg{mice} package).
}
\examples{
\donttest{
#Please see the package repository <https://github.com/FarhadPishgar/MatchIt.mice> for details.

#Loading and preparing the 'handoa' dataset
data(handoa)
idenoa <- handoa["ID"]
handoa <- handoa[c("AGE", "SEX", "BMI", "SMOKING", "HANDUSE", "KNEEOA", "HANDOA")]

#Imputing the missing data points in the'handoa' dataset
datasets <- mice(handoa, m = 5, maxit = 10)

#Binding the dataframe, 'idenoa', to each imputed dataset of the 'datasets' object
datasets <- binditmice(datasets, idenoa)
}
}
\references{
Stef van Buuren and Karin Groothuis-Oudshoorn (2011). \code{mice}: Multivariate Imputation by Chained Equations in \code{R}. \emph{Journal of Statistical Software}, 45(3): 1-67. \url{https://www.jstatsoft.org/v45/i03/}
}
\seealso{
\code{\link[=matchitmice]{matchitmice}}

\code{\link[=weightitmice]{weightitmice}}

\code{\link[=mergeitmice]{mergeitmice}}
}
\author{
Farhad Pishgar
}
\keyword{functions}
