% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilMWRyscale.R
\name{utilMWRyscale}
\alias{utilMWRyscale}
\title{Get logical value for y axis scaling}
\usage{
utilMWRyscale(accdat, param, yscl = c("auto", "log", "linear"))
}
\arguments{
\item{accdat}{\code{data.frame} for data quality objectives file for accuracy as returned by \code{\link{readMWRacc}}}

\item{param}{character string to first filter results by a parameter in \code{"Characteristic Name"}}

\item{yscl}{character indicating one of \code{"auto"} (default), \code{"log"}, or \code{"linear"}, see details}
}
\value{
A logical value indicating \code{TRUE} for log10-scale, \code{FALSE} for arithmetic (linear)
}
\description{
Get logical value for y axis scaling
}
\examples{
# accuracy path
accpth <- system.file('extdata/ExampleDQOAccuracy.xlsx', 
     package = 'MassWateR')

# accuracy data
accdat <- readMWRacc(accpth)

# log auto
utilMWRyscale(accdat, param = 'E.coli')

# linear force
utilMWRyscale(accdat, param = 'E.coli', yscl = 'linear')

# linear auto
utilMWRyscale(accdat, param = 'DO')

# log force
utilMWRyscale(accdat, param = 'DO', yscl = 'log')
}
