% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/training.R
\name{train_magmaclust}
\alias{train_magmaclust}
\title{Training MagmaClust with a Variational EM algorithm}
\usage{
train_magmaclust(
  data,
  nb_cluster = NULL,
  prior_mean_k = NULL,
  ini_hp_k = NULL,
  ini_hp_i = NULL,
  kern_k = "SE",
  kern_i = "SE",
  ini_mixture = NULL,
  common_hp_k = TRUE,
  common_hp_i = TRUE,
  grid_inputs = NULL,
  pen_diag = 1e-10,
  n_iter_max = 25,
  cv_threshold = 0.001,
  fast_approx = FALSE
)
}
\arguments{
\item{data}{A tibble or data frame. Columns required: \code{ID}, \code{Input}
, \code{Output}. Additional columns for covariates can be specified.
The \code{ID} column contains the unique names/codes used to identify each
individual/task (or batch of data).
The \code{Input} column should define the variable that is used as
reference for the observations (e.g. time for longitudinal data). The
\code{Output} column specifies the observed values (the response
variable). The data frame can also provide as many covariates as desired,
with no constraints on the column names. These covariates are additional
inputs (explanatory variables) of the models that are also observed at
each reference \code{Input}.}

\item{nb_cluster}{A number, indicating the number of clusters of
individuals/tasks that are assumed to exist among the dataset.}

\item{prior_mean_k}{The set of hyper-prior mean parameters (m_k) for the K
mean GPs, one value for each cluster.
cluster. This argument can be specified under various formats, such as:
\itemize{
\item NULL (default). All hyper-prior means would be set to 0 everywhere.
\item A numerical vector of the same length as the number of clusters.
Each number is associated with one cluster, and considered
to be the hyper-prior mean parameter of the cluster (i.e. a constant
function at all \code{Input}).
\item A list of functions. Each function is associated with one cluster. These
functions are all evaluated at all \code{Input} values, to provide
specific hyper-prior mean vectors for each cluster.
}}

\item{ini_hp_k}{A tibble or data frame of hyper-parameters
associated with \code{kern_k}, the mean process' kernel.
Required column : \code{ID}. The \code{ID} column contains the unique
names/codes used to identify each cluster. The other columns
should be named according to the hyper-parameters that are used in
\code{kern_k}.}

\item{ini_hp_i}{A tibble or data frame of hyper-parameters
associated with \code{kern_i}, the individual processes' kernel.
Required column : \code{ID}. The \code{ID} column contains the unique
names/codes used to identify each individual/task. The other columns
should be named according to the hyper-parameters that are used in
\code{kern_i}.}

\item{kern_k}{A kernel function, associated with the mean GPs.
Several popular kernels
(see \href{https://www.cs.toronto.edu/~duvenaud/cookbook/}{The Kernel
Cookbook}) are already implemented and can be selected within the
following list:
\itemize{
\item "SE": (default value) the Squared Exponential Kernel (also called
Radial Basis Function or Gaussian kernel),
\item "LIN": the Linear kernel,
\item "PERIO": the Periodic kernel,
\item "RQ": the Rational Quadratic kernel.
Compound kernels can be created as sums or products of the above kernels.
For combining kernels, simply provide a formula as a character string
where elements are separated by whitespaces (e.g. "SE + PERIO"). As the
elements are treated sequentially from the left to the right, the product
operator '*' shall always be used before the '+' operators (e.g.
'SE * LIN + RQ' is valid whereas 'RQ + SE * LIN' is  not).
}}

\item{kern_i}{A kernel function, associated with the individual GPs. (See
details above in \code{kern_k}).}

\item{ini_mixture}{Initial values of the probability to belong to each
cluster for each individual (\code{\link{ini_mixture}} can be used for
a k-means initialisation. Used by default if NULL).}

\item{common_hp_k}{A boolean indicating whether hyper-parameters are common
among the mean GPs.}

\item{common_hp_i}{A boolean indicating whether hyper-parameters are common
among the individual GPs.}

\item{grid_inputs}{A vector, indicating the grid of additional reference
inputs on which the mean processes' hyper-posteriors should be evaluated.}

\item{pen_diag}{A number. A jitter term, added on the diagonal to prevent
numerical issues when inverting nearly singular matrices.}

\item{n_iter_max}{A number, indicating the maximum number of iterations of
the VEM algorithm to proceed while not reaching convergence.}

\item{cv_threshold}{A number, indicating the threshold of the likelihood gain
under which the VEM algorithm will stop. The convergence condition is
defined as the difference of elbo between two consecutive steps,
divided by the absolute value of the last one
( \eqn{(ELBO_n - ELBO_{n-1}) / |ELBO_n| } ).}

\item{fast_approx}{A boolean, indicating whether the VEM algorithm should
stop after only one iteration of the VE-step. This advanced feature is
mainly used to provide a faster approximation of the model selection
procedure, by preventing any optimisation over the hyper-parameters.}
}
\value{
A list, containing the results of the VEM algorithm used in the
training step of MagmaClust. The elements of the list are:
\itemize{
\item hp_k: A tibble containing the trained hyper-parameters for the mean
process' kernel and the mixture proportions for each cluster.
\item hp_i: A tibble containing the trained hyper-parameters for the
individual processes' kernels.
\item hyperpost: A sub-list containing the parameters of the mean processes'
hyper-posterior distribution, namely:
\itemize{
\item mean: A list of tibbles containing, for each cluster, the
hyper-posterior mean parameters evaluated at each \code{Input}.
\item cov: A list of matrices containing, for each cluster, the
hyper-posterior covariance parameter of the mean process.
\item mixture: A tibble, indicating the mixture probabilities in each
cluster for each individual.
}
\item ini_args: A list containing the initial function arguments and values
for the hyper-prior means, the hyper-parameters. In particular, if
those arguments were set to NULL, \code{ini_args} allows us to retrieve
the (randomly chosen) initialisations used during training.
\item seq_elbo: A vector, containing the sequence of ELBO values associated
with each iteration.
\item converged: A logical value indicated whether the algorithm converged.
\item training_time: Total running time of the complete training.
}
}
\description{
The hyper-parameters and the hyper-posterior distributions involved in
MagmaClust can be learned thanks to a VEM algorithm implemented in
\code{train_magmaclust}. By providing a dataset, the model hypotheses
(hyper-prior mean parameters, covariance kernels and number of clusters) and
initialisation values for the hyper-parameters, the function computes
maximum likelihood estimates of the HPs as well as the mean and covariance
parameters of the Gaussian hyper-posterior distributions of the mean
processes.
}
\details{
The user can specify custom kernel functions for the argument
\code{kern_k} and \code{kern_i}. The hyper-parameters used in the kernel
should have explicit names, and be contained within the \code{hp}
argument. \code{hp} should typically be defined as a named vector or a
data frame. Although it is not mandatory for the \code{train_magmaclust}
function to run, gradients be can provided within kernel function
definition. See for example \code{\link{se_kernel}} to create a custom
kernel function displaying an adequate format to be used in
MagmaClust.
}
\examples{
TRUE
}
