% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_GLMBoostModel.R
\name{GLMBoostModel}
\alias{GLMBoostModel}
\title{Gradient Boosting with Linear Models}
\usage{
GLMBoostModel(
  family = NULL,
  mstop = 100,
  nu = 0.1,
  risk = c("inbag", "oobag", "none"),
  stopintern = FALSE,
  trace = FALSE
)
}
\arguments{
\item{family}{optional \code{\link[mboost]{Family}} object.  Set
automatically according to the class type of the response variable.}

\item{mstop}{number of initial boosting iterations.}

\item{nu}{step size or shrinkage parameter between 0 and 1.}

\item{risk}{method to use in computing the empirical risk for each boosting
iteration.}

\item{stopintern}{logical inidicating whether the boosting algorithm stops
internally when the out-of-bag risk increases at a subsequent iteration.}

\item{trace}{logical indicating whether status information is printed during
the fitting process.}
}
\value{
\code{MLModel} class object.
}
\description{
Gradient boosting for optimizing arbitrary loss functions where
component-wise linear models are utilized as base-learners.
}
\details{
\describe{
  \item{Response Types:}{\code{binary}, \code{numeric}, \code{Surv}}
  \item{\link[=TunedModel]{Automatic Tuning} of Grid Parameters:}{
    \code{mstop}
  }
}

Default values for the \code{NULL} arguments and further model details can be
found in the source links below.
}
\examples{
library(MASS)

fit(type ~ ., data = Pima.tr, model = GLMBoostModel)

}
\seealso{
\code{\link[mboost]{glmboost}}, \code{\link[mboost]{Family}},
\code{\link{fit}}, \code{\link{resample}}
}
