% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrainedModels.R
\name{TunedModel}
\alias{TunedModel}
\title{Tuned Model}
\usage{
TunedModel(
  model,
  grid = MachineShop::settings("grid"),
  fixed = NULL,
  control = MachineShop::settings("control"),
  metrics = NULL,
  stat = MachineShop::settings("stat.Train"),
  cutoff = MachineShop::settings("cutoff")
)
}
\arguments{
\item{model}{\link[=models]{model} function, function name, or call defining
the model to be tuned.}

\item{grid}{\link[=data.frame]{data frame} containing parameter values at
which to evaluate a single model supplied to \code{models}, such as that
returned by \code{\link{expand_params}}; the number of parameter-specific
values to generate automatically if the model has a pre-defined grid; or a
call to \code{\link{Grid}} or \code{\link{ParameterGrid}}.}

\item{fixed}{list of fixed parameter values to combine with those in
\code{grid}.}

\item{control}{\link[=controls]{control} function, function name, or call
defining the resampling method to be employed.}

\item{metrics}{\link[=metrics]{metric} function, function name, or vector of
these with which to calculate performance.  If not specified, default
metrics defined in the \link{performance} functions are used.  Model
selection is based on the first calculated metric.}

\item{stat}{function or character string naming a function to compute a
summary statistic on resampled metric values for model tuning.}

\item{cutoff}{argument passed to the \code{metrics} functions.}
}
\value{
\code{TunedModel} class object that inherits from \code{MLModel}.
}
\description{
Model tuning over a grid of parameter values.
}
\details{
\describe{
  \item{Response Types:}{\code{factor}, \code{numeric}, \code{ordered},
    \code{Surv}}
}
}
\examples{
\donttest{# Automatically generated grid
model_fit <- fit(sale_amount ~ ., data = ICHomes,
                 model = TunedModel(GBMModel))
varimp(model_fit)
(tuned_model <- as.MLModel(model_fit))
summary(tuned_model)
plot(tuned_model, type = "l")

# Randomly sampled grid points
fit(sale_amount ~ ., data = ICHomes,
    model = TunedModel(GBMModel, grid = Grid(length = 1000, random = 5)))

# User-specified grid
fit(sale_amount ~ ., data = ICHomes,
    model = TunedModel(GBMModel,
                       grid = expand_params(n.trees = c(50, 100),
                                            interaction.depth = 1:2,
                                            n.minobsinnode = c(5, 10))))}

}
\seealso{
\code{\link{fit}}, \code{\link{resample}}
}
