% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsmooth.region.plot.R
\name{unsmooth.region.plot}
\alias{unsmooth.region.plot}
\title{A Function for Plotting Pearson Correlation Coefficients in a Given Genomic Region}
\usage{
unsmooth.region.plot(plot.list, plot.chr, plot.start, plot.stop,
  plot.column = "R", plot.points = TRUE, plot.lines = TRUE,
  gene.names = TRUE, annot.colors = c("black", "red", "green", "blue",
  "cyan"), vert.pad = 0.05, num.ticks = 5, ylim.low = NULL,
  ylim.high = NULL, pch.vec = NULL, lty.vec = NULL, lwd.vec = NULL,
  plot.legend = TRUE, legend.loc = "topright")
}
\arguments{
\item{plot.list}{A list produced by corr.list.compute().}

\item{plot.chr}{The chromosome for which gene-level R or R^2 values will be plotted.}

\item{plot.start}{The genomic position (in base pairs) where the plot will start.}

\item{plot.stop}{The genomic position (in base pairs) where the plot will stop.}

\item{plot.column}{"R" or "R^2" depending on whether Pearson correlation coefficients or squared Pearson
correlation coefficients will be plotted.  Default = "R^2".}

\item{plot.points}{Logical value specifying whether points should be included in the plot.  Default = TRUE.}

\item{plot.lines}{Logical values specifying whether points should be connected by lines.  Default = FALSE.}

\item{gene.names}{Logical value specifying whether gene names should appear on the plot.  Default = FALSE.}

\item{annot.colors}{A vector of colors used for plotting values in different entries of plot.list.  Default = c("black", "red", "green", "blue", "cyan").}

\item{vert.pad}{Amount of vertical white space in the plot.  Default = 0.05.}

\item{num.ticks}{Number of ticks on the x-axis.  Default = 5.}

\item{ylim.low}{Smallest value on the y-axis (used to control the range of values on the y-axis).  Default = NULL.}

\item{ylim.high}{Largest value on the y-axis (used to control the range of values on the y-axis).  Default = NULL.}

\item{pch.vec}{Vector specifying point characters for plotting values in different entries of plot.list.  Default = NULL.  See \code{\link{par}}.}

\item{lty.vec}{Vector specifying line types for plotting values in different entries of plot.list.  Default = NULL.  See \code{\link{par}}.}

\item{lwd.vec}{Vector specifying line widths for plotting values in different entries of  plot.list.  Default = NULL.  See \code{\link{par}}.}

\item{plot.legend}{Logical value specifying whether a legend should be included.  Default = FALSE.}

\item{legend.loc}{Character value specifing the location of the legend.  Default = "topright".  See See \code{\link{legend}}}
}
\value{
Creates a plot of gene-level R or R^2 values produced by corr.list.compute().
}
\description{
This function plots unsmoothed R or R^2 values produced by corr.list.compute() in a specified genomic region.
}
\examples{
exp.mat = tcga.exp.convert(exp.mat)

 cn.mat = tcga.cn.convert(cn.mat)

 prepped.data = data.prep(exp.mat, cn.mat, gene.annot, sample.annot, log.exp = FALSE)

 pd.exp = prepped.data[["exp"]]

 pd.cn = prepped.data[["cn"]]

 pd.ga = prepped.data[["gene.annot"]]

 pd.sa = prepped.data[["sample.annot"]]

 output.list = corr.list.compute(pd.exp, pd.cn, pd.ga, pd.sa)

 unsmooth.region.plot(plot.list = output.list, plot.chr = 11, plot.start = 69e6, plot.stop = 70.5e6)

}
