% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generates_transformation_function.R
\name{generates_normalization_function}
\alias{generates_normalization_function}
\title{Function to generate the data normalization function}
\usage{
generates_normalization_function(unit_space_data, unit_space_center,
  unit_space_scale, is_scaled = TRUE)
}
\arguments{
\item{unit_space_data}{Matrix with n rows (samples) and p columns (variables).
Data to generate the unit space. All data should be
continuous values and should not have missing values.}

\item{unit_space_center}{Vector with length p. The values are subtrahends in
normalization. If missing, the mean for each
column of \code{unit_space_data} is used for
normalization.}

\item{unit_space_scale}{Vector with length p. The values are divisors in
normalization. If missing and \code{is_scaled} is
\code{TRUE}, then the unbiased standard deviation
for each column of \code{unit_space_data} is used
for normalization.}

\item{is_scaled}{Logical. If \code{TRUE} (default value), normalization is
conducted by subtracting \code{unit_space_center} and
dividing by \code{unit_space_scale}. If \code{FALSE},
normalization is conducted by subtracting
\code{unit_space_center} only.}
}
\value{
Function is returned which takes an n x p matrix as an (only)
          argument and returns a normalized n x p matrix. The normalization
          is conducted based on \code{unit_space_data}.
}
\description{
\code{generates_normalization_function} returns the data normalization
  function. The data normalization function is generated based on
  \code{unit_space_data}.
}
\examples{
# 40 data for versicolor in the iris dataset
iris_versicolor <- iris[61:100, -5]

normalizes_data <- generates_normalization_function(iris_versicolor)

is.function(normalizes_data) # TRUE

}
\seealso{
\code{\link{MT}} and \code{\link{MTA}}
}

