% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mas.R
\name{mas}
\alias{mas}
\title{Multiscalar Absolute Synthesis}
\usage{
mas(x, var1, var2, ref = NULL, key, spdf, order = NULL, dist = NULL,
  mat = NULL, spdfid = NULL, xid = NULL)
}
\arguments{
\item{x}{a data frame.}

\item{var1}{name of the numerator variable in x.}

\item{var2}{name of the denominator variable in x.}

\item{ref}{ratio of reference; if NULL, the ratio of reference is the one of 
the whole study area (\code{sum(var1) / sum(var2)}).}

\item{key}{aggregation key field.}

\item{spdf}{a SpatialPolygonsDataFrame that matches x data frame.}

\item{order}{contiguity order.}

\item{dist}{distance threshold defining the contiguity. The cartesian 
distance between units centroids is used by default 
(see \code{\link{gDistance}}); use mat to apply different metrics.}

\item{mat}{a distance matrix (road distance, travel time...) between x units. 
Row and column names must fit xid identifiers. (optional)}

\item{spdfid}{identifier field in spdf, default to the first column 
of the spdf data frame. (optional)}

\item{xid}{identifier field in x, default to the first column 
of x. (optional)}
}
\value{
A dataframe including the mass of numerator to redistribue to reach a perfect equilibrium 
according to the 3 contexts, expressed in numerator measure unit and as a share of the numerator mass.
}
\description{
This function sums the total amount of redistributions according to the three absolute 
deviations (global, territorial, spatial).
}
\examples{
data("GrandParisMetropole")
redistr <- mas(spdf = com.spdf,
                       x = com,
                       spdfid = "DEPCOM",
                       xid = "DEPCOM",
                       var1 = "INC",
                       var2 = "TH",
                       order = 2,
                       key = "EPT",
                       dist = NULL,
                       mat = NULL)
redistr
}
