% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_minimal_intervals.R
\name{compute_minimal_intervals}
\alias{compute_minimal_intervals}
\title{Computes the set of minimal intervals as described in Duembgen (2002)}
\usage{
compute_minimal_intervals(dataset)
}
\arguments{
\item{dataset}{Set of the intervals.
It needs to contain the following columns:
"startpoint" - left end of the interval;
"endpoint"   - right end of the interval.}
}
\value{
Subset of minimal intervals
}
\description{
Given a set of intervals, this function computes
             the corresponding subset of minimal intervals which are defined
             as follows. For a given set of intervals \eqn{\mathcal{K}},
             all intervals \eqn{\mathcal{I}_k \in \mathcal{K}}
             such that  \eqn{\mathcal{K}} does not contain a proper subset of
             \eqn{\mathcal{I}_k} are called minimal.

             This function is needed for illustrative purposes.
             The set of all the intervals where our test rejects the null
             hypothesis may be quite large, hence, we would like to focus
             our attention on the smaller subset, for which we are still
             able to make simultaneous confidence intervals. This subset
             is the subset of minimal intervals, and it helps us to
             to precisely locate the intervals of further interest.

             More details can be found in Duembgen (2002) and
             Khismatullina and Vogt (2019, 2020)
}
\examples{
startpoint   <- c(0, 0.5, 1)
endpoint     <- c(2, 2, 2)
dataset      <- data.frame(startpoint, endpoint)
minimal_ints <- compute_minimal_intervals(dataset)
}
