% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_auxiliary.R
\name{plot_composition}
\alias{plot_composition}
\title{Plot composition data}
\usage{
plot_composition(
  Year = 1:nrow(obs),
  obs,
  fit = NULL,
  plot_type = c("annual", "bubble_data", "bubble_residuals", "mean"),
  N = rowSums(obs),
  CAL_bins = NULL,
  ages = NULL,
  ind = 1:nrow(obs),
  annual_ylab = "Frequency",
  annual_yscale = c("proportions", "raw"),
  bubble_adj = 5,
  bubble_color = c("black", "white"),
  fit_linewidth = 3,
  fit_color = "red"
)
}
\arguments{
\item{Year}{A vector of years.}

\item{obs}{A matrix of either length or age composition data. For lengths, rows and columns
should index years and length bin, respectively. For ages, rows and columns should index
years and age, respectively.}

\item{fit}{A matrix of predicted length or age composition from an assessment model.
Same dimensions as obs.}

\item{plot_type}{Indicates which plots to create. Options include annual distributions,
bubble plot of the data, and bubble plot of the residuals, and annual means.}

\item{N}{Annual sample sizes. Vector of length \code{nrow(obs)}.}

\item{CAL_bins}{A vector of lengths corresponding to the columns in \code{obs}.
and \code{fit}. Ignored for age data.}

\item{ages}{An optional vector of ages corresponding to the columns in \code{obs}.}

\item{ind}{A numeric vector for plotting a subset of rows (which indexes year) of \code{obs} and \code{fit}.}

\item{annual_ylab}{Character string for y-axis label when \code{plot_type = "annual"}.}

\item{annual_yscale}{For annual composition plots (\code{plot_type = "annual"}), whether the raw values
("raw") or frequencies ("proportions") are plotted.}

\item{bubble_adj}{Numeric, for adjusting the relative size of bubbles in bubble plots
(larger number = larger bubbles).}

\item{bubble_color}{Colors for negative and positive residuals, respectively, for bubble plots.}

\item{fit_linewidth}{Argument \code{lwd} for fitted line.}

\item{fit_color}{Color of fitted line.}
}
\value{
Plots depending on \code{plot_type}.
}
\description{
Plots annual length or age composition data.
}
\examples{
\donttest{
data(Red_snapper)
plot_composition(obs = Red_snapper@CAA[1, , ], plot_type = "annual")
plot_composition(obs = Red_snapper@CAA[1, , ], plot_type = "bubble_data")

plot_composition(obs = Red_snapper@CAL[1, , ], plot_type = "annual", Red_snapper@CAL_bins[1:43])
plot_composition(obs = Red_snapper@CAL[1, , ], plot_type = "bubble_data",
CAL_bins = Red_snapper@CAL_bins[1:43])
}
}
\author{
Q. Huynh
}
