% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SS2Data.R
\name{SS2Data}
\alias{SS2Data}
\title{Reads data Stock Synthesis file structure into a Data object using package r4ss}
\usage{
SS2Data(
  SSdir,
  Name = "Object generated by SS2Data function",
  Common_Name = "",
  Species = "",
  Region = "",
  min_age_M = 1,
  gender = 1,
  comp_fleet = "all",
  comp_season = "sum",
  comp_partition = "all",
  comp_gender = "all",
  index_fleet = "SSB",
  index_season = "mean",
  ...
)
}
\arguments{
\item{SSdir}{A folder with Stock Synthesis input and output files in it}

\item{Name}{The name for the Data object}

\item{Common_Name}{Character string for the common name of the stock.}

\item{Species}{Scientific name of the species}

\item{Region}{Geographic region of the stock or fishery.}

\item{min_age_M}{Currently, the Data object supports a single value of M for all ages. The argument selects the
minimum age for calculating the mean of age-dependent M from the SS assessment.}

\item{gender}{An integer index for the sex for which life history values are importing (1 = female, 2 = male).}

\item{comp_fleet}{A vector of indices corresponding to fleets in the assessment over which to aggregate the composition
(catch-at-length and catch-at-age) data. By default, characer string \code{"all"} will aggregate across all fleets.}

\item{comp_season}{Integer, for seasonal models, the season for which the value of the index will be used. By default, \code{"mean"}
will take the average across seasons.}

\item{comp_partition}{Integer vector for selecting length/age observations that are retained (2), discarded (1), or both (0). By default, \code{"all"}
sums over all available partitions.}

\item{comp_gender}{Integer vector for selecting length/age observations that are female (1), male (2), or both (0), or both scaled to sum to one (3).
By default, \code{"all"} sums over all gender codes.}

\item{index_fleet}{Integer for selecting the fleet of the index to put in the Data object. By default, \code{"SSB"}
will use the relative trend in spawning stock biomass as estimated in the model as the index.}

\item{index_season}{Integer, for seasonal models, the season for which the value of the index will be used. By default, \code{"mean"}
will take the average across seasons.}

\item{...}{Arguments to pass to \link[r4ss]{SS_output}}
}
\value{
An object of class Data.
}
\description{
A function that uses the file location of a fitted SS3 model including input files to population
the various slots of an Data object.
}
\note{
Currently supports the  version of r4ss on CRAN (v.1.24) and Github (v.1.34-35). Function may be incompatible with other versions of r4ss.
}
\seealso{
\link{SS2OM}
}
\author{
T. Carruthers and Q. Huynh
}
