% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeQuartetHypTest.R
\name{quartetTestPlot}
\alias{quartetTestPlot}
\title{Produce simplex plot with  results of quartet hypothesis tests}
\usage{
quartetTestPlot(pTable, test, alpha = 0.05, beta = 1, cex = 1)
}
\arguments{
\item{pTable}{table of quartets and p-values, as produced by \code{quartetTreeTestInd},
\code{quartetStarTestInd}, or \code{NANUQ}}

\item{test}{model to use, for tree null hypothesis; options are \code{"T1"}, \code{"T3"}, \code{"cut"}, \code{"NANUQ"}}

\item{alpha}{level for tree test with null hypothesis given by \code{test}}

\item{beta}{level for test with null hypothesis star tree;
test results plotted only if \code{beta<1} and \code{"p_star"} column present in \code{pTable}}

\item{cex}{scaling factor for size of plotted symbols}
}
\description{
Plot a 2-d probability simplex, with points for all quartet count vectors. Colors
indicate rejection or failure to reject for tests at specified levels.
}
\details{
The first argument of this function is a table of quartets and p-values. The
plot may show results of either the T1, T3, or 2-cut
test, with or without a star tree test (depending on whether a \code{"p_star"} column is in the table and/or \code{beta =1}).
The p-values must be computed by previous calls to
\code{quartetTreeTestInd} (for \code{"T1"} or \code{"T3"} p-values)
and \code{quartetStarTestInd} (for \code{"star"} p-values). The \code{NANUQ} and \code{NANUQdist}
functions include calls to these tree test functions.
}
\examples{
gtrees=read.tree(file=system.file("extdata","dataGeneTreeSample",package="MSCquartets"))
tnames=c("t1","t2","t3","t4","t5","t6")
QT=quartetTable(gtrees,tnames[1:6])
RQT=quartetTableResolved(QT)
stree="(((t5,t6),t4),((t1,t2),t3));"
pTable=quartetTreeTestInd(RQT,"T1",speciestree=stree)
pTable=quartetStarTestInd(pTable)
quartetTestPlot(pTable, "T1", alpha=.05, beta=.95)

}
\seealso{
\code{\link{quartetTreeTestInd}}, \code{\link{quartetStarTestInd}},
\code{\link{NANUQ}}, \code{\link{NANUQdist}}
}
