% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToBtoLevel1.R
\name{circHybOrders}
\alias{circHybOrders}
\title{Generate all circular orders with designated hybrid}
\usage{
circHybOrders(n)
}
\arguments{
\item{n}{size of order, with n>3}
}
\value{
an (n!/2)xn  (or 3xn if n=4) matrix whose rows give all circular orders.
}
\description{
Generate a matrix whose rows give all circular orders with a designated hybrid.
The order is encoded as a vector with entries from 1 to n, where the position
corresponds to a node/group of taxa.  The location in the vector of the 1
indicates the hybrid, the positions of 2, n its neighbors, etc.
}
\details{
To avoid duplication of circular orders, the entry 2 in each vector
always occurs before the entry n.

Since in using first-order quartet-based methods to infer 4-cycles the hybrid
node is not identifiable, for n=4 only 3 orders are given, with 1 as hybrid for each
}
\examples{
circHybOrders(4)
circHybOrders(5)

}
