% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_binary.R
\docType{data}
\name{data_binary}
\alias{data_binary}
\title{A synthetic data set of an MRT with binary proximal outcomes}
\format{
A data frame with 3000 observations and 10 variables:
\describe{
  \item{userid}{Individual id number.}
  \item{time}{Decision point index.}
  \item{time_var1}{Time-varying covariate 1, the \"standardized time in study\",
    defined as the current decision point index divided by the total number
    of decision points.}
  \item{time_var2}{Time-varying covariate 2, indicator of \"the second half of the study\",
    defined as whether the current decision point index is greater than the total number
    of decision points divided by 2.}
  \item{Y}{Binary proximal outcome.}
  \item{A}{Treatment assignment: whether the intervention is randomized to be delivered (=1)
    or not (=0) at the current decision point.}
  \item{rand_prob}{Randomization probability \eqn{P(A=1)} for the current decision point.}
  \item{avail}{Availability indicator (=1 available, =0 not available) at the current decision point.}
}
}
\usage{
data_binary
}
\description{
Baseline model:
\deqn{\log E\{Y_{t+1} \mid A_t = 0, I_t = 1\} =
      \alpha_0 + \alpha_1 \cdot \mathrm{time} / \mathrm{total\_T}
      + \alpha_2 \cdot \mathbf{1}(\mathrm{time} > \mathrm{total\_T}/2).}

Treatment effect model:
\deqn{\log RR_t = \beta_0 + \beta_1 \cdot \mathrm{time} / \mathrm{total\_T}.}

Randomization probabilities \eqn{p_t} cycle over 0.3, 0.5, 0.7 (with repetition).
Availability is exogenous at 0.8 for all time points.
}
\keyword{datasets}
