% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/summary.mrs.R
\name{summary.mrs}
\alias{summary.mrs}
\title{Summary of a mrs object}
\usage{
\method{summary}{mrs}(object, rho = 0.5, abs_eff = 0, sort_by = "eff",
  ...)
}
\arguments{
\item{object}{A \code{mrs} object}

\item{rho}{Threshold for the posterior alternative probability.
All regions with posterior alternative probability larger
than \code{rho} are reported. Default is \code{rho = 0.5}.}

\item{abs_eff}{Threshold for the effect size. All regions with
effect size larger than \code{abs_eff} in absolute value are reported.
Default is \code{abs_eff = 0}.}

\item{sort_by}{Define in which order the regions are reported.
The options are \code{sort_by = c("eff", "prob")} and
the default is \code{sort_by = "eff"}.}

\item{...}{Additional summary parameters.}
}
\value{
A \code{list} with information about the top regions.
}
\description{
This function summarizes the output of the \code{\link{mrs}} function.
It provides the marginal prior and posterior null and
the top regions of the representative tree.
}
\examples{
set.seed(1)
n = 100
p = 2
X = matrix(c(runif(p*n/2),rbeta(p*n/2, 1, 4)), nrow=n, byrow=TRUE)
G = c(rep(1,n/2), rep(2,n/2))
object = mrs(X=X, G=G)
fit = summary(object, rho = 0.5, abs_eff = 0.1)
}
\references{
Soriano J. and Ma L. (2017).
Probabilistic multi-resolution scanning for two-sample differences.
 \emph{Journal of the Royal Statistical Society: Series B (Statistical Methodology)}.
 \doi{10.1111/rssb.12180}

Ma L. and Soriano J. (2018).
Analysis of distributional variation through multi-scale Beta-Binomial modeling.
 \emph{Journal of Computational and Graphical Statistics. Vol. 27, No. 3, 529-541.}.
 \doi{10.1080/10618600.2017.1402774}
}

