% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.r
\docType{data}
\name{pttuna}
\alias{pttuna}
\title{pttuna is yellowfin tuna fishery data from Pella-Tomlinson 1969}
\format{
A data.frame of fisheries data
\describe{
  \item{year}{the fishing year from 1934 - 1967}
  \item{catch}{the total annual catch, '000s of pounds }
  \item{effort}{the total effort as standard class 4 baitboat fishing days}
  \item{cpue}{the catch '000 pounds per standard class 4 day, a ratio cpue}
}
}
\source{
from Table 6 page 457 in Pella, J.J. and P.K. Tomlinson (1969) A 
    Generalized Stock Production Model. \emph{Bulletin, Inter-American 
    Tropical Tuna Commission} 13(3): 421-458. Obtainable from 
    \emph{https://www.iattc.org/BulletinsENG.htm}
}
\description{
pttuna is yellowfin tuna fishery data from Pella-Tomlinson's
    (1969) classical paper describing their generalized surplus production 
    model. This is the same data as contained in the schaef data-set, except
    it is extended from 1934 - 1967. Some of the values are slightly 
    different, and their table rounds off the cpue estimates slightly 
    differently but the catch and effort figures are theirs. It contains 
    the year, the catch, the effort, and the cpue (which is just the total
    catch divided by the total effort, a ratio estimate). Initial parameter 
    estimates close to the optimum values for the Schaefer model could be
    param <- log(c(r=0.28,K=2100000,Binit=2400000,sigma=0.16)). With this
    longer time-series the eventual MSY estimate was somewhat larger than 
    when just the schaef data are used.
}
\section{Subjects}{

 \itemize{
   \item surplus production modelling
   \item classical fisheries data
   \item Log-Normal likelihoods
 }
}

\examples{
 data(pttuna)
 pars <- log(c(r=0.25,K=2.1e06,Binit=2.2e06,sigma=0.2))
 answer <- fitSPM(pars,pttuna,schaefer=TRUE,maxiter=1000)
 outfit(answer,title="Pella-Tomlinson Data",digits=4)
}
