% Generated by roxygen2 (4.0.2): do not edit by hand
\name{segmentationAroma}
\alias{segmentationAroma}
\title{segmentation function}
\usage{
segmentationAroma(dataSetName, normalTumorArray, chromosome = 1:22,
  method = c("cghseg", "PELT"), Kmax, Rho = NULL, listOfFiles = NULL,
  onlySNP = TRUE, savePlot = TRUE, verbose = TRUE)
}
\arguments{
\item{dataSetName}{The name of the data-set folder (it must correspond to a folder name in rawData folder.).}

\item{normalTumorArray}{Only in the case of normal-tumor study. A csv file or a data.frame containing the mapping between normal and tumor files
The first column contains the name of normal files and the second the names of associated tumor files.}

\item{chromosome}{A vector with the chromosomes to be segmented.}

\item{method}{method of segmentation, either "PELT" or "cghseg".}

\item{Kmax}{For method="cghseg", maximal number of segments.}

\item{Rho}{For method="PELT", vector containing all the penalization values to test for the segmentation. If no values are provided, default values will be used.}

\item{listOfFiles}{A vector containing the names of the files in dataSetName folder for which the copy number profiles will be segmented (default is all the files).}

\item{onlySNP}{If TRUE, only the copy-number for SNPs positions will be returned (default=TRUE).}

\item{savePlot}{if TRUE, graphics of the segmented CN signal will be saved in the figures/dataSetName/segmentation/CN folder. (default=TRUE).}

\item{verbose}{if TRUE print some informations}
}
\value{
a list containing
\describe{
  \item{copynumber}{A vector containing  the copynumber signal.}
  \item{segmented}{A vector of the same size as copynumber containing the segmented values.}
  \item{startPos}{The position of each probes.}
  \item{chromosome}{A vector of the same size as copynumber containing the chromosome number.}
  \item{featureNames}{Names of the probes.}
  \item{sampleNames}{The name of the signal.}
  \item{segment}{A data.frame that summarizes the results of the segmentation. Each row is a different segment with the chromosome, start position, end position, number of probes in the signal and the value of the segment.}
}
}
\description{
This function launches the segmentation process using the aroma architecture.
}
\author{
Quentin Grimonprez
}

