% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mod_dirs.R
\name{get_mod_dirs}
\alias{get_mod_dirs}
\title{Get list of MODIS data folders from http server}
\usage{
get_mod_dirs(
  http,
  download_server,
  user,
  password,
  yy,
  n_retries,
  gui,
  out_folder_mod
)
}
\arguments{
\item{http}{\code{character} http site on lpdaac corresponding to the selected MODIS
product}

\item{download_server}{\code{character ["http" | "offline"]} download service
to be used; if NA, the script tries to download with http.}

\item{user}{\code{character} username for earthdata http server}

\item{password}{\code{character} password for earthdata http server}

\item{yy}{\code{character} Year for which the folder containing HDF images are to
be identified}

\item{n_retries}{\code{numeric} number of times the access to the http server
should be retried in case of error before quitting, Default: 20}

\item{gui}{`logical`` indicates if processing was called from the GUI
environment or not. If not, processing messages are sent to a log file
instead than to the console/GTK progress windows.}

\item{out_folder_mod}{\code{character} output folder for MODIS HDF storage}
}
\value{
\verb{character arraay} listing all available folders (a.k.a. dates) for
the requested MODIS product on lpdaac http archive, for the years
included in the time range selected for processing.
}
\description{
Accessory function to get the full list of directories on the
lpdaac http site containing data included in the time range selected for
processing (modified after Barry Rowlingson function):
}
\note{
License: GPL 3.0
}
\author{
Original code by Babak Naimi (\code{.getModisList}, in
\href{http://r-gis.net/?q=ModisDownload}{ModisDownload.R})
modified to adapt it to MODIStsp scheme and to http archive (instead than old
FTP) by:

Lorenzo Busetto, phD (2014-2017) \email{busetto.l@irea.cnr.it}

Luigi Ranghetti, phD (2016-2017) \email{lbusett@gmail.com}
}
