% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMLR.R
\name{Aver_soj_time}
\alias{Aver_soj_time}
\title{Calculating average sojourn time in each state}
\usage{
Aver_soj_time(ii, tau_observed, Q)
}
\arguments{
\item{ii}{number (scalar), currently 1 or 2}

\item{tau_observed}{number (scalar), observed time}

\item{Q}{Matrix (m x m, currently m = 2, see Details}
}
\value{
Vector of average sojourn times in each state.
Vector components in total should give observation time (tau_observed).
}
\description{
Calculating expectation of sojourn times in states (currently two states)
for the observed time and for given initial state, using eigenvalues and eigenvectors.
}
\details{
Calculating expectation of sojourn times in states 1 and 2 for the observed time (tau_observed) and if initial state is given (ii).
Matrix Q is so-called Generator matrix: Q = lambda – Lambda, where lambda is matrix with transition rates from state s_i to state s_j,
and Lambda is diagonal matrix with a vector (Lambda_1, …, Lambda_m) on the main diagonal, where m is a number of states of external environment (currently m = 2).
Eigenvalues and eigenvectors are used in calculations.
}
\examples{
lambda <- matrix(c(0, 0.33, 0.45, 0), nrow = 2, ncol = 2, byrow = TRUE)
m <- nrow(lambda)
ld <- as.matrix(rowSums(lambda))
Lambda <- diag(as.vector(ld))
Generator <- t(lambda) - Lambda
Aver_soj_time(1,10,Generator)
\donttest{Aver_soj_time(2,5,Generator)}
}
