% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.GaF.R
\name{plot.GaF}
\alias{plot.GaF}
\title{Plot the GaF object}
\usage{
\method{plot}{GaF}(
  x,
  xlab = "Time",
  ylab = "Cumulative hazard",
  type = "s",
  lty = 1,
  lwd = 1,
  col = gray(0),
  digits = 4,
  ...
)
}
\arguments{
\item{x}{The GaF object, see \code{\link{GaFrailtyMM}}.}

\item{xlab}{x label, default is 'Time'.}

\item{ylab}{y label, default is 'Cumulative hazard'.}

\item{type}{type value, default is 's'.}

\item{lty}{lty value for line, default is 1.}

\item{lwd}{line width, default is 1.}

\item{col}{color parameter, default is gray(0).}

\item{digits}{The digits after the decimal point, default = 4.}

\item{...}{Additional arguments}
}
\value{
the dataframe of 'Time' and accumulative hazard \eqn{\Lambda}.
}
\description{
Plot the GaF object
}
\examples{
library(survival)
result <- GaFrailtyMM(Surv(time, status) ~ age + sex + cluster(id), data=kidney)
plot(result)

}
