% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchicalFDR.R
\name{selFDR}
\alias{selFDR}
\title{Selection from hierarchical testing with FDR control}
\usage{
selFDR(out, alpha = 0.05, global = TRUE, outer = TRUE)
}
\arguments{
\item{out}{output of \link{hierarchicalFDR} function}

\item{alpha}{control level for test}

\item{global}{if FALSE the provided alpha is the desired level control for each family.}

\item{outer}{if TRUE, the FDR is controlled only on outer node (rejected groups without rejected children). 
If FALSE, it is controlled on the full tree.}
}
\value{
a list containing:
\describe{
  \item{toSel}{vector of boolean. TRUE if the group is selected}
  \item{groupId}{Names of groups}
  \item{local.alpha}{control level for each family of hypothesis}
  \item{global.alpha}{control level for the tree (full tree or outer node)}
  }
}
\description{
Select groups from hierarchical testing procedure with FDR control (\link{hierarchicalFDR})
}
\details{
See the reference for mode details about the method.

If each family is controlled at a level alpha, we have the following control:
FDR control of full tree: alpha * delta * 2  (delta = 1.44)
FDR control of outer node: alpha * L * delta * 2 (delta = 1.44)
}
\examples{
set.seed(42)
X <- simuBlockGaussian(50, 12, 5, 0.7)
y <- X[, c(2, 7, 12)] \%*\% c(2, 2, -2) + rnorm(50, 0, 0.5)
res <- MLGL(X, y)
test <- hierarchicalFDR(X, y, res$group[[20]], res$var[[20]])
sel <- selFDR(test, alpha = 0.05)
}
\references{
Yekutieli, Daniel. "Hierarchical False Discovery Rate-Controlling Methodology." 
Journal of the American Statistical Association 103.481 (2008): 309-16.
}
\seealso{
\link{hierarchicalFDR}
}
